/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.java;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.integrator.adaptors.java.VWJavaBaseDialog;
import filenet.vw.integrator.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Node;

class VWJavaOperationsDialog
extends VWJavaBaseDialog
implements ActionListener,
ListSelectionListener {
    public VWJavaOperationsDialog(Frame parentFrame, String componentDescriptor, ClassLoader classLoader) throws Exception {
        super(parentFrame, componentDescriptor, classLoader);
        this.initialize();
    }

    public VWJavaOperationsDialog(Dialog parent, String componentDescriptor, ClassLoader classLoader) throws Exception {
        super(parent, componentDescriptor, classLoader);
        this.initialize();
    }

    public String[] getOperationDescriptors() {
        try {
            Object[] methods = this.m_methodList.getSelectedValues();
            if (methods != null && methods.length > 0) {
                String[] descriptors = new String[methods.length];
                for (int nIndex = 0; nIndex < methods.length; ++nIndex) {
                    descriptors[nIndex] = this.getOperationDescriptor((Method)methods[nIndex]);
                }
                return descriptors;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object.equals(this.m_okButton)) {
            this.m_nStatus = 1;
            this.setVisible(false);
        } else if (object.equals(this.m_cancelButton)) {
            this.m_nStatus = 0;
            this.setVisible(false);
        } else if (object.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc081.htm");
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (event.getSource().equals(this.m_methodList)) {
            this.m_okButton.setEnabled(event.getFirstIndex() != -1);
        }
    }

    private void initialize() {
        try {
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_javaOperationsDialogDim);
            if (dim == null) {
                dim = new Dimension(600, 350);
            }
            this.setSize(dim);
            this.setTitle(VWResource.s_javaOperationsDialogTitle);
            this.setVisible(false);
            String className = "";
            if (this.m_xmlWrapper != null) {
                String value = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "jar_file_url");
                if (value != null) {
                    this.m_sourceFileTextField = new JTextField(value);
                }
                className = VWXMLWrapper.getNodeValue(this.m_xmlWrapper.getRootNode(), "target_class");
            }
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.getMainPanel(className), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
            this.initMethodList(className);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel(String className) {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.insets = new Insets(4, 4, 4, 4);
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            JLabel label = new JLabel(VWResource.s_javaClass);
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_javaClass, VWResource.s_javaClass);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            JLabel classLabel = new JLabel();
            if (className != null) {
                classLabel.setText(className);
            }
            panel.add((Component)classLabel, gbCons);
            VWAccessibilityHelper.setAccessibility(classLabel, this, className, className);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            label = new JLabel(VWResource.s_availableMethods);
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_javaClass, VWResource.s_javaClass);
            gbCons.gridwidth = 3;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.5;
            this.m_methodList = new JList();
            this.m_methodList.addListSelectionListener(this);
            panel.add((Component)new JScrollPane(this.m_methodList), gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_methodList, this, label.getText(), label.getText());
            VWAccessibilityHelper.setLabelFor(label, this.m_methodList);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private String getOperationDescriptor(Method method) {
        try {
            VWXMLWrapper xmlWrapper = new VWXMLWrapper("fnpe_operation_descriptor", "http://www.filenet.com/xml/schemas/FNPE/1.0.0");
            Node rootNode = xmlWrapper.getRootNode();
            xmlWrapper.createNodeNamed(rootNode, "name", method.getName());
            xmlWrapper.createNodeNamed(rootNode, "description", "");
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int nIndex = 0; nIndex < parameterTypes.length; ++nIndex) {
                int nType = this.getFieldType(parameterTypes[nIndex].getName());
                if (nType == -1) {
                    Container parent = this.getParent();
                    if (parent instanceof Frame) {
                        JOptionPane.showMessageDialog((Frame)parent, VWResource.s_invalidParameterTypes.toString(method.getName()), VWResource.s_error, 0);
                    } else if (parent instanceof Dialog) {
                        JOptionPane.showMessageDialog((Dialog)parent, VWResource.s_invalidParameterTypes.toString(method.getName()), VWResource.s_error, 0);
                    }
                    return null;
                }
                Node parameter = xmlWrapper.createNodeNamed(rootNode, "parameter", null);
                xmlWrapper.createNodeNamed(parameter, "name", "param" + (nIndex + 1));
                xmlWrapper.createNodeNamed(parameter, "type", Integer.toString(nType));
                xmlWrapper.createNodeNamed(parameter, "mode", Integer.toString(1));
                xmlWrapper.createNodeNamed(parameter, "isarray", String.valueOf(parameterTypes[nIndex].isArray()));
                xmlWrapper.createNodeNamed(parameter, "description", "");
            }
            Class<?> returnType = method.getReturnType();
            String returnTypeName = returnType.getName();
            if (returnTypeName != null && !returnTypeName.equals("void")) {
                int nType = this.getFieldType(returnTypeName);
                if (nType == -1) {
                    Container parent = this.getParent();
                    if (parent instanceof Frame) {
                        JOptionPane.showMessageDialog((Frame)parent, VWResource.s_invalidParameterTypes.toString(method.getName()), VWResource.s_error, 0);
                    } else if (parent instanceof Dialog) {
                        JOptionPane.showMessageDialog((Dialog)parent, VWResource.s_invalidParameterTypes.toString(method.getName()), VWResource.s_error, 0);
                    }
                    return null;
                }
                Node parameter = xmlWrapper.createNodeNamed(rootNode, "parameter", null);
                xmlWrapper.createNodeNamed(parameter, "name", "return_value");
                xmlWrapper.createNodeNamed(parameter, "type", Integer.toString(nType));
                xmlWrapper.createNodeNamed(parameter, "mode", Integer.toString(2));
                xmlWrapper.createNodeNamed(parameter, "isarray", String.valueOf(returnType.isArray()));
                xmlWrapper.createNodeNamed(parameter, "description", "");
            }
            xmlWrapper.createNodeNamed(rootNode, "signature", method.toString());
            return xmlWrapper.toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private int getFieldType(String parameterTypeName) {
        if (parameterTypeName.equals("int")) {
            return 1;
        }
        if (parameterTypeName.equals("boolean")) {
            return 4;
        }
        if (parameterTypeName.equals("double")) {
            return 8;
        }
        if (parameterTypeName.equals("short")) {
            return 1;
        }
        if (parameterTypeName.equals("float")) {
            return 8;
        }
        if (parameterTypeName.equals("long")) {
            return 8;
        }
        if (parameterTypeName.equals("java.lang.Integer")) {
            return 1;
        }
        if (parameterTypeName.equals("java.lang.Boolean")) {
            return 4;
        }
        if (parameterTypeName.equals("java.lang.Double")) {
            return 8;
        }
        if (parameterTypeName.equals("java.lang.Short")) {
            return 1;
        }
        if (parameterTypeName.equals("java.lang.Float")) {
            return 8;
        }
        if (parameterTypeName.equals("java.lang.Long")) {
            return 8;
        }
        if (parameterTypeName.equals("java.util.Date")) {
            return 16;
        }
        if (parameterTypeName.equals("java.lang.String")) {
            return 2;
        }
        if (parameterTypeName.equals("filenet.vw.api.VWAttachment")) {
            return 32;
        }
        if (parameterTypeName.equals("filenet.vw.api.VWParticipant")) {
            return 64;
        }
        if (parameterTypeName.equals("[I")) {
            return 1;
        }
        if (parameterTypeName.equals("[Z")) {
            return 4;
        }
        if (parameterTypeName.equals("[D")) {
            return 8;
        }
        if (parameterTypeName.equals("[S")) {
            return 1;
        }
        if (parameterTypeName.equals("[F")) {
            return 8;
        }
        if (parameterTypeName.equals("[J")) {
            return 8;
        }
        if (parameterTypeName.equals("[Ljava.lang.Integer;")) {
            return 1;
        }
        if (parameterTypeName.equals("[Ljava.lang.Boolean;")) {
            return 4;
        }
        if (parameterTypeName.equals("[Ljava.lang.Double;")) {
            return 8;
        }
        if (parameterTypeName.equals("[Ljava.lang.Short;")) {
            return 1;
        }
        if (parameterTypeName.equals("[Ljava.lang.Float;")) {
            return 8;
        }
        if (parameterTypeName.equals("[Ljava.lang.Long;")) {
            return 8;
        }
        if (parameterTypeName.equals("[Ljava.util.Date;")) {
            return 16;
        }
        if (parameterTypeName.equals("[Ljava.lang.String;")) {
            return 2;
        }
        if (parameterTypeName.equals("[Lfilenet.vw.api.VWAttachment;")) {
            return 32;
        }
        if (parameterTypeName.equals("[Lfilenet.vw.api.VWParticipant;")) {
            return 64;
        }
        return -1;
    }
}

